<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://aheadoftheweb.com/
 * @since             1.0.0
 * @package           Aow_Hub_Node
 *
 * @wordpress-plugin
 * Plugin Name:       AOW HUB NODE
 * Plugin URI:        https://aheadoftheweb.com/
 * Description:       This plugin communicates with a HUB NETWORK to get business information and save it on the site
 * Version:           1.0.0
 * Author:            Graeme
 * Author URI:        https://aheadoftheweb.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       aow-hub-node
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'AOW_HUB_NODE_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-aow-hub-node-activator.php
 */
function activate_aow_hub_node() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-aow-hub-node-activator.php';
	Aow_Hub_Node_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-aow-hub-node-deactivator.php
 */
function deactivate_aow_hub_node() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-aow-hub-node-deactivator.php';
	Aow_Hub_Node_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_aow_hub_node' );
register_deactivation_hook( __FILE__, 'deactivate_aow_hub_node' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-aow-hub-node.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_aow_hub_node() {

	$plugin = new Aow_Hub_Node();
	$plugin->run();

}
run_aow_hub_node();
