<?php
/**
 * Adds Clinic_Hours widget.
 */

class Aow_Hub_Node_Widget_Clinic_Hours extends WP_Widget {

  /**

   * Register widget with WordPress

   */

  public function __construct( $admin ) {

    parent::__construct(

      'aow_hub_node_widget_clinic_hours', // Base ID

      __( 'AOW HUB NODE Clinic Hours', 'text_domain' ), // Widget Name

      array( 'description' => __( 'Display Clinic Hours', 'text_domain' ), ) // Widget Description

    );
	  
	$this->admin = $admin;

  }

  /**

   * Front-end display of widget

   */

  public function widget( $args, $instance ) {

    //Our variables from the widget settings.
	

    $title = apply_filters( 'widget_title', $instance[ 'title' ] );

    $daylength = $instance[ 'daylength' ];

    //$cip = get_option( 'aow_cip_object' );
    $show_while_closed = ( array_key_exists( 'show_while_closed', $instance ) ) ? $instance[ 'show_while_closed' ] : 0;
	  
	$id = ( array_key_exists( 'id', $instance ) ) ? $instance[ 'id' ] : '';
    
	//$cipobject = json_decode( $cip, true );

    // Output widget to page

    echo $args[ 'before_widget' ];

    if ( empty( $title ) ) {

      $title = "Our Hours";

    }

    //$aow_cip_temp_closure = aow_cip_temp_closure();
    $aow_cip_temp_closure = '';
	global $aow_get_clinic_info_id;
	$aow_get_clinic_info_id = $id;
	$hours_array = $this->admin->helper->get_hours_array();
	$aow_get_clinic_info_id = FALSE;
	if ( $aow_cip_temp_closure ) {
      $hours = $aow_cip_temp_closure;
      if ( $show_while_closed ) {
        $hours .= $this->admin->helper->populate_aow_hub_node_hours_list( $hours_array, $daylength );
      }
    } else {
      $hours = $this->admin->helper->populate_aow_hub_node_hours_list( $hours_array, $daylength );
    }

    echo $args[ 'before_title' ] . $title . $args[ 'after_title' ];

    echo __( $hours, 'text_domain' );

    echo $args[ 'after_widget' ];

  }

  /**

   * Back-end widget form

   */

  public function form( $instance ) {

    // Get title if there is one, if not set default title

    if ( isset( $instance[ 'title' ] ) && $instance[ 'title' ] != '' ) {

      $title = $instance[ 'title' ];

    } else {

      $title = __( 'Our Hours', 'text_domain' );

    }

    // Create form for setting title

    ?>
<p>
  <label for="<?php echo $this->get_field_id( 'title' ); ?>">
    <?php _e( 'Title:' ); ?>
  </label>
  <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
</p>
<?php
	  // Get title if there is one, if not set default title

    if ( isset( $instance[ 'id' ] ) && $instance[ 'id' ] != '' ) {

      $id = $instance[ 'id' ];

    } else {

      $id = __( '', 'text_domain' );

    } 
	  
	// Create form for setting id

    ?>
<p>
  <label for="<?php echo $this->get_field_id( 'id' ); ?>">
    <?php _e( 'ID:' ); ?>
  </label>
  <input class="widefat" id="<?php echo $this->get_field_id( 'id' ); ?>" name="<?php echo $this->get_field_name( 'id' ); ?>" type="text" value="<?php echo esc_attr( $id ); ?>" />
</p>
<?php

// Get day length if there is one, if not set default day length

if ( isset( $instance[ 'daylength' ] ) && $instance[ 'daylength' ] != '' ) {

  $daylength = $instance[ 'daylength' ];

} else {

  $daylength = 1;

}

// Create form for setting title

?>
<p>
  <label for="<?php echo $this->get_field_id( 'daylength' ); ?>">
    <?php _e( 'Length of Day:' ); ?>
  </label>
  <br />
  <br />
  <input id="<?php echo $this->get_field_id('daylength'); ?>" name="<?php echo $this->get_field_name('daylength'); ?>" type="radio" value="1" <?php checked( '1', $daylength ); ?>/>
  <label for="<?php echo $this->get_field_id('daylength'); ?>">
    <?php _e('Long Form (ie: Monday)'); ?>
  </label>
<p>
  <input id="<?php echo $this->get_field_id('daylength'); ?>" name="<?php echo $this->get_field_name('daylength'); ?>" type="radio" value="2" <?php checked( '2', $daylength ); ?>/>
  <label for="<?php echo $this->get_field_id('daylength'); ?>">
    <?php _e('Short Form (ie: Mon)'); ?>
  </label>
</p>
<?php

// Get day length if there is one, if not set default day length

if ( isset( $instance[ 'show_while_closed' ] ) && $instance[ 'show_while_closed' ] != '' ) {

  $show_while_closed = $instance[ 'show_while_closed' ];

} else {

  $show_while_closed = 0;

}

// Create form for setting title

?>
<p>
  <label for="<?php echo $this->get_field_id( 'show_while_closed' ); ?>">
    <?php _e( 'Show Hours While Closed:' ); ?>
  </label>
  <br />
  <br />
  <input id="<?php echo $this->get_field_id('show_while_closed'); ?>" name="<?php echo $this->get_field_name('show_while_closed'); ?>" type="radio" value="0" <?php checked( '0', $show_while_closed ); ?>/>
  <label for="<?php echo $this->get_field_id('show_while_closed'); ?>">
    <?php _e('Do not show hours while clinic is under temporary closure'); ?>
  </label>
<p>
  <input id="<?php echo $this->get_field_id('show_while_closed'); ?>" name="<?php echo $this->get_field_name('show_while_closed'); ?>" type="radio" value="1" <?php checked( '1', $show_while_closed ); ?>/>
  <label for="<?php echo $this->get_field_id('show_while_closed'); ?>">
    <?php _e('Yes show clinic hours under temporary closure message'); ?>
  </label>
</p>
</p>
<?php

}

/**

 * Sanitize widget form values as they are saved.

 */

public function update( $new_instance, $old_instance ) {

  $instance = array();

  $instance[ 'title' ] = ( !empty( $new_instance[ 'title' ] ) ) ? strip_tags( $new_instance[ 'title' ] ) : '';
	
  $instance[ 'id' ] = ( !empty( $new_instance[ 'id' ] ) ) ? strip_tags( $new_instance[ 'id' ] ) : '';

  $instance[ 'daylength' ] = ( !empty( $new_instance[ 'daylength' ] ) ) ? strip_tags( $new_instance[ 'daylength' ] ) : '';
  $instance[ 'show_while_closed' ] = ( !empty( $new_instance[ 'show_while_closed' ] ) ) ? strip_tags( $new_instance[ 'show_while_closed' ] ) : '';

  return $instance;

}

}
