<?php

/**
 * The sub-class that manages the clinic custom post type
 *
 * @link       https://aheadoftheweb.com/
 * @since      1.0.0
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/admin
 */

/**
 * The sub-class that manages the clinic custom post type
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/admin
 * @author     Graeme <Gibson>
 */
class Aow_Hub_Node_CPT_Language extends Aow_Hub_Node_CPT {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;
	
	/**
	 * ID, Text Domain
	 *
	 * @var string
	 * @since  1.2.0
	 */
	protected $ID = 'clinic-language';

	public $posttype = 'clinic-language';

	public $singular = 'Language';
	
	public $key = 'languageid';
	
	public $name = 'language_name';
	
	public $posttablename = 'aow_hub_languages';
	
	/**
	 * Menu Slug
	 *
	 * @var string
	 * @since  1.2.0
	 */
	public $menuSlug = 'language-settings';


	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin ) {
		$this->admin = $plugin;
		parent::__construct(
			array( __( 'Clinic Language', 'clinic' ), __( 'Clinic Languages', 'clinic' ), 'clinic-language' ),
			array( 'supports' => array( 'title', 'editor', 'excerpt', 'thumbnail' ), )
		);
		
	}
	
	public function get_meta( $cip ){
		$meta_fields = array(
			'cip'				=> json_encode( $cip ),
			'languageid'		=> $cip->id,
			'language_name'		=> $cip->language_name,
		);
		return $meta_fields;
	}

}
?>