<?php

/**
 * Customizer functionality of the plugin.
 *
 * @link       https://aheadoftheweb.com/
 * @since      1.0.0
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/customizer
 */

/**
 * The Customizer functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/customizer
 * @author     Graeme <Gibson>
 */
class Aow_Hub_Node_Customizer {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;
	
	/**
	 * Array of customizer fields
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      field_array    $version    Array of customizer fields
	 */
	private $field_array;
	
	/**
	 * Array of days of the week
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      day_array    $version    Array of days of the week
	 */
	private $day_array;
	
	/**
	 * Array of openning and closing hours options
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      $hour_array    $version    Array of openning and closing hours options
	 */
	private $hour_array;
	
	
	private $admin;
	
	public $posttype = 'default';

	public $singular = 'Default';
	
	public $key = 'clinicid';
	
	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $admin ) {

		$this->admin = $admin;
		$this->hour_array = $this->get_hour_array();
		$this->week_array = $this->get_week_array();
		$this->field_array = $this->get_field_array();
		
		add_action( 'customize_register', array( $this, 'add_customize_register' ) );
		// Uncomment below line to allow for custom CSS options
		//add_action( 'wp_head', array( $this, 'aow_bim_customize_css' ) );
	}
	
	public function get_option( $option, $custom_default = FALSE ){
		$option_pre = 'aow_';
		$option = $option_pre . $option;
		$custom_default = ( $custom_default ) ? $custom_default : 'No Data set';
		$data = get_theme_mod( $option, $custom_default );
		return $data;
	}
	
	public function set_option( $options ){
		$data = FALSE;
		$field_sections = $this->admin->cpt[ 'default' ]->get_field_array();
		if( !is_array( $options ) ){
			$options[ $options ] = $options;
		}
		$protected_fields = $this->admin->get_protected_fields( 'default' );
		foreach( $field_sections as $field_section ){
			foreach( $field_section as $field ){
				$option_name = substr( $field[ 'id' ], 4 );
				if( array_key_exists( $option_name, $options ) ){
					if( !array_key_exists( $option_name, $protected_fields ) || isset( $protected_fields[ $option_name ] ) && $protected_fields[ $option_name ] == 'FALSE' ){
						set_theme_mod( $field[ 'id' ], $options[ $option_name ][ 0 ] );
						$data = TRUE;
					}
				}
			}
		}
		return $data;
	}
	
	public function get_meta( $cip ){
		/*
		$meta_fields = array(
			'cip'				=> json_encode( $cip ),
			'languageid'		=> $cip->id,
			'language_name'		=> $cip->name,
		);
		*/
		return $meta_fields;
	}

	
	
	/**
	 * Get array of all fields
	 *
	 * @since    1.0.0
	 * @param      string    field_array    Get array of all fields.
	 */
	public function get_field_array(){
		$field_array = array(
			'bim_bus_options' => array(
				array(
					'id'		=> 'aow_clinic_name',
					'label'		=> 'Business Name',
				),
				array(
					'id'		=> 'aow_telephone',
					'label'		=> 'Business Number',
				),
				array(
					'id'		=> 'aow_fax',
					'label'		=> 'Business Fax Number',
				),
				array(
					'id'		=> 'aow_email',
					'label'		=> 'Business Email',
				),
				array(
					'id'		=> 'aow_websiteurl',
					'label'		=> 'Business Website URL',
				),
				array(
					'id'		=> 'aow_profileurl',
					'label'		=> 'Business Profile URL',
				),
				array(
					'id'		=> 'aow_street',
					'label'		=> 'Business Street Address',
				),
				// Not yet added to CIP
				/*array(
					'id'		=> 'bus_address_unit',
					'label'		=> 'Business Unit Number (if any)',
				),*/
				array(
					'id'		=> 'aow_city',
					'label'		=> 'Business City',
				),
				array(
					'id'		=> 'aow_province',
					'label'		=> 'Business Province',
				),
				array(
					'id'		=> 'aow_country',
					'label'		=> 'Business Country',
				),
				array(
					'id'		=> 'aow_postal_code',
					'label'		=> 'Business Postal Code',
				),
			),
			'bim_addt_info'	=> array(
				array(
					'id'		=> 'aow_logo',
					'label'		=> 'Business Logo',
					'custom'	=> 'image',
				),
				array(
					'id'		=> 'aow_image',
					'label'		=> 'Business Image',
					'custom'	=> 'image',
				),
				array(
					'id'		=> 'aow_description',
					'label'		=> 'Business Description',
				),
				array(
					'id'		=> 'aow_emergency_status',
					'label'		=> 'Business Emergency Status',
				),
				array(
					'id'		=> 'aow_emergency_message',
					'label'		=> 'Business Emergency Message',
				),
				
				array(
					'id'		=> 'aow_virtual_tour',
					'label'		=> 'Google Virtual Tour URL',
				),
				
				array(
					'id'		=> 'aow_facebookurl',
					'label'		=> 'Business Facebook Page URL',
				),
				/*
				array(
					'id'		=> 'bus_facebook_id',
					'label'		=> 'Business Facebook Page ID',
					'description'	=> 'Find ID here: <a target="blank" href="http://findmyfbid.com/">Facebook Page ID Finder</a>',
				),
				*/
				array(
					'id'		=> 'aow_yelp_reviews_id',
					'label'		=> 'Business Yelp Profile URL',
					'description'	=> 'E.g. https://www.yelp.com/biz/bayview-lonsdale-dentist-north-vancouver',
				),
				/*
				array(
					'id'		=> 'aow_yelp_slug',
					'label'		=> 'Business Yelp Biz Slug',
					'description'	=> 'E.g. bayview-lonsdale-dentist-north-vancouver',
				),*/
				array(
					'id'		=> 'aow_yelp_id',
					'label'		=> 'Business Yelp Biz ID',
					'description'	=> 'E.g. jihR65PLI6u0fQsteNkCOw',
				),
				array(
					'id'		=> 'aow_google_plus',
					'label'		=> 'Business Google Place URL',
					'description'	=> 'E.g. https://plus.google.com/+BayviewLonsdaleDentistNorthVancouver/',
				),
				array(
					'id'		=> 'aow_map',
					'label'		=> 'Business Google Map',
					'description'	=> 'E.g. ChIJrVQRXUdwhlQRhZD27ljUhag',
				),
				array(
					'id'		=> 'aow_google_api',
					'label'		=> 'Business Google Maps API',
					'description'	=> 'E.g. AIzaSyBSSOw5R239CJekW2Ri244XEuKbluVJlOA',
				),
				array(
					'id'		=> 'aow_latitude',
					'label'		=> 'Business Latitude',
				),
				array(
					'id'		=> 'aow_longitude',
					'label'		=> 'Business Longitude',
				),
			),
			'bim_promo'	=> array(
				array(
					'id'		=> 'aow_promotion_title',
					'label'		=> 'Promotion Title',
					'ignore'	=> 'true',
				),
				array(
					'id'		=> 'aow_promotion_content',
					'label'		=> 'Promotion Content',
					'ignore'	=> 'true',
				),
				array(
					'id'		=> 'aow_override_parent_control',
					'label'		=> 'Override Parent Control',
					'ignore'	=> 'true',
				),
			),
			'bim_group'	=> array(
				array(
					'id'		=> 'aow_clinic_count',
					'label'		=> 'Total Clinics',
					'ignore'	=> 'true',
				),
			),
		);
		
		$week_array_settings = array();
		foreach( $this->week_array as $k => $v ){
			
			array_push( $week_array_settings,
				array(
					'id'		=> 'aow_' . $k . '_open',
					'label'		=> 'Hours ' . $v . ' Open',
					'default'	=> 'default',
					'type'		=> 'select',
					'choices'	=> $this->hour_array,
				)
			);
			array_push( $week_array_settings,
				array(
					'id'		=> 'aow_' . $k . '_closed',
					'label'		=> 'Hours ' . $v . ' Closed',
					'default'	=> 'default',
					'type'		=> 'select',
					'choices'	=> $this->hour_array,
				)
			);
			array_push( $week_array_settings,
				array(
					'id'		=> 'aow_' . $k . '_msg',
					'label'		=> 'Hours ' . $v . ' Message',
				)		   
			);
		}
		
		$field_array[ 'bim_hours_loc' ] = $week_array_settings;
		
		return $field_array;
	}
	
	/**
	 * Get array of all the days in the week.
	 *
	 * @since    1.0.0
	 * @param      string    week_array    Get array of all the days in the week.
	 */
	public function get_week_array(){
		
		$week_array = array(
			'mon'	=> 'Monday',
			'tue'	=> 'Tuesday',
			'wed'	=> 'Wednesday',
			'thu'	=> 'Thursday',
			'fri'	=> 'Friday',
			'sat'	=> 'Saturday',
			'sun'	=> 'Sunday',
		);
		
		return $week_array;
	}
	
	/**
	 * Get array of all options for an openning/closing hours select field
	 *
	 * @since    1.0.0
	 * @param      string    hour_array    Get array of all options for an openning/closing hours select field
	 */
	public function get_hour_array(){
		$hour_array = array( 
			'default'	=> 'Select Hours',
			'closed' => 'Closed',
			'0000' => '00:00',
			'0015' => '00:15',
			'0030' => '00:30',
			'0045' => '00:45',
			'0100' => '01:00',
			'0115' => '01:15',
			'0130' => '01:30',
			'0145' => '01:45',
			'0200' => '02:00',
			'0215' => '02:15',
			'0230' => '02:30',
			'0245' => '02:45',
			'0300' => '03:00',
			'0315' => '03:15',
			'0330' => '03:30',
			'0345' => '03:45',
			'0400' => '04:00',
			'0415' => '04:15',
			'0430' => '04:30',
			'0445' => '04:45',
			'0500' => '05:00',
			'0515' => '05:15',
			'0530' => '05:30',
			'0545' => '05:45',
			'0600' => '06:00',
			'0615' => '06:15',
			'0630' => '06:30',
			'0645' => '06:45',
			'0700' => '07:00',
			'0715' => '07:15',
			'0730' => '07:30',
			'0745' => '07:45',
			'0800' => '08:00',
			'0815' => '08:15',
			'0830' => '08:30',
			'0845' => '08:45',
			'0900' => '09:00',
			'0915' => '09:15',
			'0930' => '09:30',
			'0945' => '09:45',
			'1000' => '10:00',
			'1015' => '10:15',
			'1030' => '10:30',
			'1045' => '10:45',
			'1100' => '11:00',
			'1115' => '11:15',
			'1130' => '11:30',
			'1145' => '11:45',
			'1200' => '12:00',
			'1215' => '12:15',
			'1230' => '12:30',
			'1245' => '12:45',
			'1300' => '13:00',
			'1315' => '13:15',
			'1330' => '13:30',
			'1345' => '13:45',
			'1400' => '14:00',
			'1415' => '14:15',
			'1430' => '14:30',
			'1445' => '14:45',
			'1500' => '15:00',
			'1515' => '15:15',
			'1530' => '15:30',
			'1545' => '15:45',
			'1600' => '16:00',
			'1615' => '16:15',
			'1630' => '16:30',
			'1645' => '16:45',
			'1700' => '17:00',
			'1715' => '17:15',
			'1730' => '17:30',
			'1745' => '17:45',
			'1800' => '18:00',
			'1815' => '18:15',
			'1830' => '18:30',
			'1845' => '18:45',
			'1900' => '19:00',
			'1915' => '19:15',
			'1930' => '19:30',
			'1945' => '19:45',
			'2000' => '20:00',
			'2015' => '20:15',
			'2030' => '20:30',
			'2045' => '20:45',
			'2100' => '21:00',
			'2115' => '21:15',
			'2130' => '21:30',
			'2145' => '21:45',
			'2200' => '22:00',
			'2215' => '22:15',
			'2230' => '22:30',
			'2245' => '22:45',
			'2300' => '23:00',
			'2315' => '23:15',
			'2330' => '23:30',
			'2345' => '23:45',
		);
		return $hour_array;
	} 
	
	
	public function add_customize_register( $wp_customize ) {

		$settings_array = $this->field_array;
		
		foreach( $settings_array as $k => $v ){
			foreach( $v as $setting ){
				// Get fields with possible entries and set defaults
				$default = ( array_key_exists( 'default', $setting ) ) ? $setting[ 'default' ] : 'No ' . $setting[ 'label' ] . ' Set';
				$description = ( array_key_exists( 'description', $setting ) ) ? $setting[ 'description' ] : '';
				$type = ( array_key_exists( 'type', $setting ) ) ? $setting[ 'type' ] : '';
				$choices = ( array_key_exists( 'choices', $setting ) ) ? $setting[ 'choices' ] : '';
				
				// Begin creating settings
				$wp_customize->add_setting( $setting[ 'id' ],
					array( 'default' => $default ) );
				// Create control settings array
				$control_settings_array = array(
                    'label'        	=> __( $setting[ 'label' ], 'mytheme' ),
                    'description'	=> $description,
                    'section'    	=> $k,
                    'settings'   	=> $setting[ 'id' ],
                    'type'			=> $type,
                    'choices'		=> $choices,
                );
				// Apply the correct customizer class
				if( array_key_exists( 'custom', $setting ) ){
					// if statements to account for different customize types
					if( $setting[ 'custom' ] == 'image' ){
						// Unset unused properties to avoid errors
						unset( $control_settings_array[ 'type' ] );
						unset( $control_settings_array[ 'choices' ] );
							$wp_customize->add_control( new WP_Customize_Image_Control( 
							$wp_customize, $setting[ 'id' ], $control_settings_array
							) 
						);
					}
				}else{
					$wp_customize->add_control(
						$setting[ 'id' ], $control_settings_array
					);
				}
			}
		}
			
		
		//// Main Panel Section
		// Setup main Customizer Panel
		$wp_customize->add_panel( 'bim_panel', array(
			'priority'       => 10,
			'capability'     => 'edit_theme_options',
			'theme_supports' => '',
			'title'          => __('Business Information Manager', 'mytheme'),
			'description'    => __('Use the below fields to enter your business info to better manage your data consistency.', 'mytheme'),
		) );
		
		//// Sub-Panel Section
		// Setup Sub-Panel For Business & Contact Info
		$sub_panel_array = array(
			array(
				'section'	=> 'bim_bus_options',
				'title'		=> 'Business & Contact Info',
			),array(
				'section'	=> 'bim_addt_info',
				'title'		=> 'Additional Business Info',
			),array(
				'section'	=> 'bim_hours_loc',
				'title'		=> 'Business Hours & Location',
			),array(
				'section'	=> 'bim_promo',
				'title'		=> 'Business Promotions',
			),
			array(
				'section'	=> 'bim_group',
				'title'		=> 'Group Info',
			),
		);
		
		foreach( $sub_panel_array as $sub_panel ){
			$wp_customize->add_section( $sub_panel[ 'section' ], array(
				'title'		=> $sub_panel[ 'title' ],
				'priority'	=> 10,
				'panel'		=> 'bim_panel',
			) );
		}

	}
	
	private function aow_bim_customize_css(){
	   /* ?>
	   <style type="text/css">
		   div#main-container { background-color: <?php echo get_theme_mod('content_color', 'ffffff'); ?>; }
		   body { 
			  background-color: <?php echo get_theme_mod('page_grad_top_color', '000000'); ?>;
			  background: -moz-linear-gradient(top,  <?php echo get_theme_mod('page_grad_top_color', '000000'); ?> 0%, <?php echo get_theme_mod('page_grad_btm_color', '000000'); ?> 100%);
			  background: -webkit-linear-gradient(top,  <?php echo get_theme_mod('page_grad_top_color', '000000'); ?> 0%,<?php echo get_theme_mod('page_grad_btm_color', '000000'); ?> 100%);
			  background: linear-gradient(to bottom,  <?php echo get_theme_mod('page_grad_top_color', '000000'); ?> 0%,<?php echo get_theme_mod('page_grad_btm_color', '000000'); ?> 100%);
			  filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='<?php echo get_theme_mod('page_grad_top_color', '000000'); ?>', endColorstr='<?php echo get_theme_mod('page_grad_btm_color', '000000'); ?>',GradientType=0 );
		   }
		   div#head { background-color: <?php echo get_theme_mod('page_header_color', 'ffffff'); ?>; }
		   div#foot { background-color: <?php echo get_theme_mod('page_footer_color', 'ffffff'); ?>; }

	   </style>
		<?php */
	}
	
	public function abbreviate_province( $province ){
		$ap = '';
		$province = $province;
		switch( $province ){
			case 'Alberta':
				$ap = 'AB';
				break;
			case 'British Columbia':
				$ap = 'BC';
				break;
			case 'Manitoba':
				$ap = 'MB';
				break;
			case 'New Brunswick':
				$ap = 'NB';
				break;
			case 'Newfoundland and Labrador':
				$ap = 'NL';
				break;
			case 'Northwest Territories':
				$ap = 'NT';
				break;
			case 'Nova Scotia':
				$ap = 'NS';
				break;
			case 'Nunavut':
				$ap = 'NU';
				break;
			case 'Ontario':
				$ap = 'ON';
				break;
			case 'Prince Edward Island':
				$ap = 'PE';
				break;
			case 'Quebec':
				$ap = 'QC';
				break;
			case 'Saskatchewan':
				$ap = 'SK';
				break;
			case 'Yukon':
				$ap = 'YT';
				break;
		}
		return $ap;
	}
	
	function time_return($time, $end, $ampm = "uppercase", $trailingzeros, $ampmseparator, $twentyfourhourtime = "false" ){
		$twentyfourhourtime = $twentyfourhourtime;
		$colon = '';

		if ($ampmseparator == "yes"):		
			if( $twentyfourhourtime == 'true' ){
				$time = date("G:i a",strtotime(str_pad($time,4,'0',STR_PAD_LEFT)));
			}else{
				$time = date("g:i a",strtotime(str_pad($time,4,'0',STR_PAD_LEFT)));	
			}
		else:
			if( $twentyfourhourtime == 'true' ){
				$time = date("G:ia",strtotime(str_pad($time,4,'0',STR_PAD_LEFT)));
			}else{
				$time = date("g:ia",strtotime(str_pad($time,4,'0',STR_PAD_LEFT)));
			}
		endif;

		if( $twentyfourhourtime == 'true' ){
			$am = '';
			$pm = '';
		}else{
			if( $ampm != 'none' ){
				if ($ampm == "uppercase"):	
					$am = "AM"; $pm = 'PM'; 
				else: 
					$am = 'am'; $pm = 'pm'; 
				endif;
			}else{
				 $am = "AM"; 
				 $pm = "PM";
			}
		}


		if($time >= 1200){
			if($time == 1200) {
				$time = 1200;
			} elseif($time == 1230) {
				$time = 1230;
			} elseif( $twentyfourhourtime == 'true' ){
				$time = $time;
			} else {
				if (!is_array($time)):
					$time = ($time-1200);
				endif;
			}

			if ($trailingzeros == "no" && strpos(substr($time,-6),"00") !== FALSE):
				$time = str_replace( ":00","",$time);
			else:
				$time = substr_replace( $time , $colon , -2, 0);
			endif;

			$time = str_replace("am",$am,$time);
			$time = str_replace("pm",$pm,$time);

			return $time;
			exit;

		}else{

			if ($trailingzeros == "no" && strpos(substr($time,-6),"00") !== FALSE):
				$time = str_replace(":00","",$time);
			else:
				$time = substr_replace( $time , $colon , -2, 0);
			endif;

			$time = str_replace("am",$am,$time);
			$time = str_replace("pm",$pm,$time);

			return $time;
			exit;
		}
	}
	
}
