<?php
/*
 * Use an array to search a string
 * Allows us to pass the stop words list and our post data
 */
function aow_as_bld_strpos_arr($haystack, $needle) {
    if(!is_array($needle))
    {
    	$needle = array($needle);
    }
    foreach($needle as $what) {
    	$pos = stripos($haystack, $what);
        if( $pos !== false)
        {
        	return true;
        }
    }
    return false;
}

/*
 * Our bad words validation function
 */
add_filter('gform_validation', 'aow_as_bld_custom_validation');
function aow_as_bld_custom_validation($validation_result){
    $form = $validation_result["form"];

	$stop_words = array(
		'domainworld.com',
		'domainregistercorp.com',
		'outsource',
		'intellectual property',
		'copyright',
		'Sir/Madam',
		'Sir/ Madam',
		'Sir / Madam',
		'Sir /Madam',
		'long term relationship',
		'SEO',
		'@tom.com',
		'rankings',
		'businesses',
		'responsive',
		'first page',
		'First page',
		'marketing',
		'BrandVisibility',
		'1st page',
		'ptimization',
		'targeted',
		'targetted',
		'traffic',
		'revenue',
		'more clients',
		'wpsitepatrol.com',
		'improve your rankings',
		'Improve your rankings',
		'page ranking',
		'Design',
		'design',
		'Instagram',
		'instagram',
		'followers',
		'fanpage',
		'fan page',
		'rankcatalyst.us',
		'top 10 rank',
		'Title Tag',
		'title tag',
		'CAN-SPAM',
		'guaranteed',
		'patientpowerhouse.com',
		'viagra',
		'cialis',
		'bitcoin',
		'Bitcoin',
		'BitCoin',
		'photography',
		'yandex.com',
		'yandex.ru',
		'visiomedia.ca',
		'marshjaffer@gmail.com',
		'reillyrenwick@gmail.com',
		'778-791-9600',
		'conferenceseries.com',
		'conferenceseries.net',
		'conferencesmail.org',
		'cmesociety.org',
		'businessfunding',
		'BusinessFunding',
		'casino',
		'gamer',
		'nutritionalconference.com',
		'rankaboveothers.ca',
		'493-4965',
		'dentalcongress.com',
		'https://',
		'http://',
		/*'https://goo.',
		'https://www.goo.',*/
		'payday loans',
		'getabusiness',
		'businessfunded',
		'MP3',
		'FTP',
		'a href=',
		'sex',
		'survey',
		'biz',
		'forex',
		'crypto',
		'fuck',
		'mail.ru',
		'iPhone',
		'giveaway',
		'follow',
		'database',
		'captcha',
		'mailing',
		'whitelist',
		'passive',
		'illionaire',
		'register now',
		'artificial intelligence',
		'fast income',
		'makes money',
		'make money',
		'tinyurl',
		'high volume',
		'unsubscribe',
		'waismiten.tk',
		'USA CONFIDENTIALITY NOTICE',
		'sponsored listings',
		'Tegs:',
		'й',
		'ж',
		'д',
		'б',
		'Russian Federation'	
	);

	$stop_id = array();

	foreach($_POST as $id => $post)
	{
		if(aow_as_bld_strpos_arr($post, $stop_words))
		{
			/*
			 * We have a match so store the post ID and initiate validation error
			 */	
			 $stop_id[] = $id;
		}
	}

	if(sizeof($stop_id) > 0)
	{
		$validation_result['is_valid'] = false;

		foreach($form['fields'] as &$field)
		{
			foreach($stop_id as $id)
			{
				$the_id = (int) str_replace('input_', '', $id);

				if($field['id'] == $the_id)
				{
					$field['failed_validation'] = true;
					$field['validation_message'] = 'Your submission was blocked by our anti-spam detection. If you believe this was in error, please edit your message and try again, or contact us by phone.';
				}
			}
		}
	}

    //Assign modified $form object back to the validation result
    $validation_result["form"] = $form;
    return $validation_result;

}
?>